/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.ModifyDamageAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class MetalSlug
extends AbstractCard {
    public static final String ID = "MetalSlug";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("MetalSlug");
    public static final String NAME = "Metal Slug";
    public static final String DESCRIPTION = "Deal !D! damage. NL If Fired, increase its damage by !M! for this combat.";
    private static final int COST = 1;
    private static final int DAMAGE_AMT = 5;
    private static final int INCREASE_DMG_AMOUNT = 2;
    private static final int POOL = 1;

    public MetalSlug() {
        super(ID, NAME, null, 1, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.subType = AbstractCard.CardSubType.AMMO;
        this.baseDamage = 5;
        this.magicNumber = this.baseMagicNumber = 2;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)m, new DamageInfo(p, this.damage, this.damageTypeForTurn), AbstractGameAction.AttackEffect.FIRE));
    }

    @Override
    public void fire(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m);
        AbstractDungeon.actionManager.addToBottom(new ModifyDamageAction(this, this.magicNumber));
    }

    @Override
    public AbstractCard makeCopy() {
        return new MetalSlug();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(2);
        }
    }
}

